# ARS: Automatic Routing Solver with Large Language Models


## Introduction

Real-world Vehicle Routing Problems (VRPs) are characterized by a variety of practical constraints, making manual solver design both knowledge-intensive and time-consuming. Although there is increasing interest in automating the design of routing algorithms, existing research has explored only a limited array of VRP variants and fails to adequately address the complex and prevalent constraints encountered in real-world situations.

To fill this gap, this repository introduces **ARS (Automatic Routing Solver)**, which employs Large Language Model (LLM) agents to enhance a backbone algorithm framework by automatically generating constraint-aware heuristic code, based on problem descriptions and several representative constraints selected from a database.



<div style="text-align: center;">
    <img src="https://anonymous.4open.science/r/RoutBench/Problems.png" alt="This image depicts the relationships among various VRP variants and their fundamental constraints. The nodes represent different VRP variants." style="width: 50%;">
</div>



## Key Features
- **RoutBench**: A benchmark of 1,000 VRP variants derived from 24 attributes, for evaluating the effectiveness of LLM-based routing solvers in addressing complex constraints.
- **Automatic Constraint Handling**: Automatically generates heuristic code for complex constraints using LLM agents.
- **Performance**: Outperforms state-of-the-art LLM-based methods and commonly used solvers, solving 91.67% of common VRPs and achieving at least a 30% improvement across all benchmarks.
